﻿-- Created 2019-04-30: 

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_FillCaseBufferGroupReplicate]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_sp_FillCaseBufferGroupReplicate]
GO

CREATE PROCEDURE  [dbo].[VX_sp_FillCaseBufferGroupReplicate]
	@BrowseNbr int = 100, -- Should use f(NbrLoggedAgents)
	@ProjectId int = 0, -- Normally ignored
	@GroupNbr int = 0 , -- Default 0, ignored for project Roles
	@StrGroup char(3) = 'G00',
	@UseQuotas bit = 0,
	@dncFlag int = 1,
	@isPreviewSupported bit = 1,
	@dncExpirationDate datetime = 0,
	@FilterEmptyPhone bit = 0,
	@PhoneAlias nvarchar(32) = '',
	@FreshPriority int = 0,
	@ManualFilter int = null, -- (null (default), 0, 1)
	@TotalExtractedCases int OUT
AS
	SET @TotalExtractedCases = 0
	--##############################
	-- 1: call-backs with high priority - regardless of statustemp
	--##############################
	INSERT INTO #BufferNewTemp (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode )
	SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, 
		case when @PhoneAlias = '' then Resphone else Phone.RpsContent end ResPhone, @ProjectId, Res.DialingMode 
	FROM Respondent Res with(nolock)
		left join Response Phone with(nolock) on @PhoneAlias <> '' and Res.ResRespondent = Phone.RpsRespondent and Phone.RpsQuestion = @PhoneAlias and Phone.RpsMatrix = 1 and Phone.RpsMention = 1 and Phone.RpsType = 0
	WHERE
		/*Invariable criterion (should be same for every query in this SP */
		(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
		and ((ResIntervCall = @StrGroup) or ((@StrGroup = 'G00') and ((ResIntervCall = '***') or (RTrim(ResIntervCall) = '')))) --Must be assigned to all or requested group
		and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
		and (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent)) --Prevent double insert & remove excluded
		and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE ( @dncFlag = 1 AND resphone=phone ) OR (@dncFlag = 2 AND resphone=phone AND RegistrationDate > @dncExpirationDate ))) --Exclude DNC if active
		and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
		and (@FilterEmptyPhone = 0 or ((@PhoneAlias = '' and Res.Resphone <> '') or (@PhoneAlias <> '' and Phone.RpsContent is not null and Phone.RpsContent <> '')))
		-- Role not evaluated
		/*Variable criterion*/
		and ((ResCall=1) and (ResCallbackDate >0) and (ResCallbackDate< GetUTCDate()))
		and (resPriority >= @FreshPriority)
		and (@ManualFilter is null or Res.ManualDialing = @ManualFilter)
	ORDER BY ResPriority desc, rescallbackdate, ResSeed
	SET @TotalExtractedCases = @@RowCount

	SET @BrowseNbr = @BrowseNbr - (SELECT count(*) FROM #BufferNewTemp WHERE IntGroup=@GroupNbr)

	if @BrowseNbr > 0 -- the total is not reach, continue to search for cases
	begin
		--##############################
		-- 2: fresh cases -- one at a time for replicates with statustemp <> 2
		--##############################
		INSERT INTO #BufferNewTemp (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode )
		SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, 
			case when @PhoneAlias = '' then Resphone else Phone.RpsContent end ResPhone, @ProjectId, Res.DialingMode 
		FROM Respondent Res with(nolock)
			left join Response Phone with(nolock) on @PhoneAlias <> '' and Res.ResRespondent = Phone.RpsRespondent and Phone.RpsQuestion = @PhoneAlias and Phone.RpsMatrix = 1 and Phone.RpsMention = 1 and Phone.RpsType = 0
		WHERE
			/*Invariable criterion (should be same for every query in this SP */
			(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
			and ((ResIntervCall = @StrGroup) or ((@StrGroup = 'G00') and ((ResIntervCall = '***') or (RTrim(ResIntervCall) = '')))) --Must be assigned to all or requested group
			and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
			and (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent)) --Prevent double insert & remove excluded
			and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE ( @dncFlag = 1 AND resphone=phone ) OR (@dncFlag = 2 AND resphone=phone AND RegistrationDate > @dncExpirationDate ))) --Exclude DNC if active
			and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
			and (@FilterEmptyPhone = 0 or ((@PhoneAlias = '' and Res.Resphone <> '') or (@PhoneAlias <> '' and Phone.RpsContent is not null and Phone.RpsContent <> '')))
			-- Role not evaluated
			/*Variable criterion*/
			and (ResCall=0) and (resPriority>= @freshPriority )
			and (@ManualFilter is null or Res.ManualDialing = @ManualFilter)
		ORDER BY ResPriority desc, ResSeed
		SET @TotalExtractedCases = @TotalExtractedCases + @@RowCount

	end

	SET @BrowseNbr = @BrowseNbr - (SELECT count(*) FROM #BufferNewTemp WHERE IntGroup=@GroupNbr)

	if @BrowseNbr > 0 -- the total is not reach, continue to search for cases
	begin
		--##############################
		-- 3 : call-backs with low priority - regardless of statusTemp
		--##############################
		INSERT INTO #BufferNewTemp (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode )
		SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, 
			case when @PhoneAlias = '' then Resphone else Phone.RpsContent end ResPhone, @ProjectId, Res.DialingMode 
		FROM Respondent Res with(nolock)
			left join Response Phone with(nolock) on @PhoneAlias <> '' and Res.ResRespondent = Phone.RpsRespondent and Phone.RpsQuestion = @PhoneAlias and Phone.RpsMatrix = 1 and Phone.RpsMention = 1 and Phone.RpsType = 0
		WHERE
			/*Invariable criterion (should be same for every query in this SP */
			(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
			and ((ResIntervCall = @StrGroup) or ((@StrGroup = 'G00') and ((ResIntervCall = '***') or (RTrim(ResIntervCall) = '')))) --Must be assigned to all or requested group
			and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
			and (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent)) --Prevent double insert & remove excluded
			and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE ( @dncFlag = 1 AND resphone=phone ) OR (@dncFlag = 2 AND resphone=phone AND RegistrationDate > @dncExpirationDate ))) --Exclude DNC if active
			and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
			and (@FilterEmptyPhone = 0 or ((@PhoneAlias = '' and Res.Resphone <> '') or (@PhoneAlias <> '' and Phone.RpsContent is not null and Phone.RpsContent <> '')))
			-- Role not evaluated
			/*Variable criterion*/
			and ((ResCall=1) and (ResCallbackDate >0) and (ResCallbackDate< GetUTCDate()))
			and (resPriority < @freshPriority)
			and (@ManualFilter is null or Res.ManualDialing = @ManualFilter)
		ORDER BY ResPriority desc, rescallbackdate, ResSeed
		SET @TotalExtractedCases = @TotalExtractedCases + @@RowCount
	end

GO